;========================================================================================
;  crtmodfnc.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	fnc.equ
	.include	iocscall.mac
	.include	misc.mac
	.include	vicon.equ

;----------------------------------------------------------------
;	crtmod.fnc (2025-06-29)
;----------------------------------------------------------------
;int crtmod(char mode,[char gon])
;	ʃ[hݒ肵܂B
;	mode	0`	ʃ[h
;	gon	0`1	OtBbNʂ\邩
;	߂l	0	I
;		1	X-BASIC̃o[WႢ܂
;		2	͈͊Oł
;----------------------------------------------------------------

	.text
	.even

;CtH[Ve[u
information_table:
	.dc.l	init_routine		;[`
	.dc.l	run_routine		;RUN[`
	.dc.l	end_routine		;END[`
	.dc.l	system_routine		;SYSTEM/EXIT[`
	.dc.l	break_routine		;BREAK/CTRL+C[`
	.dc.l	ctrld_routine		;CTRL+D(O֐)[`
	.dcb.l	2,reserved		;\
	.dc.l	token_table		;g[Ne[u
	.dc.l	param_table		;p[^e[u
	.dc.l	func_table		;sAhXe[u
	.dcb.l	5,0			;

;[`
init_routine:
;RUN[`
run_routine:
;END[`
end_routine:
;SYSTEM/EXIT[`
system_routine:
;BREAK/CTRL+C[`
break_routine:
;CTRL+D(O֐)[`
ctrld_routine:
;\
reserved:
	rts

;g[Ne[u
token_table:
	.dc.b	'crtmod',0
	.dc.b	0
	.even

;p[^e[u
param_table:
	.dc.l	param_crtmod

;int crtmod(char mode,[char gon])
param_crtmod:
	.dc.w	P_CHAR			;char mode
	.dc.w	P_OPT|P_CHAR		;[char gon]
	.dc.w	R_INT			;int crtmod

;sAhXe[u
func_table:
	.dc.l	func_crtmod

;----------------------------------------------------------------
;int crtmod(char mode,[char gon])
;	ʃ[hݒ肵܂B
;	mode	0`	ʃ[h
;	gon	0`1	OtBbNʂ\邩
;	߂l	0	I
;		1	X-BASIC̃o[WႢ܂
;		2	͈͊Oł
;----------------------------------------------------------------
;>d0.l:G[R[h
;>a0.l:߂l
;>a1.l:G[bZ[W
;?d1-d5/a2-a3
func_crtmod:

;X-BASIC̃o[WmF
aBAS	reg	a2			;basic.x̐擪+$8000
bas	reg	-$8000(aBAS)
	movea.l	basic_base(pc),aBAS
	if	<move.l aBAS,d0>,eq
		DOS	_GETPDB
		movea.l	d0,aBAS			;basic.x̃vZXǗ|C^
		adda.l	#240+$8000,aBAS		;basic.x̐擪+$8000
		move.l	aBAS,basic_base
		lea.l	($000002)bas,a0		;ʎq
		lea.l	basic202(pc),a1
		moveq.l	#1,d0			;'X-BASIC̃o[WႢ܂'
		moveq.l	#14/2-1,d1
		for	d1
			goto	<cmp.w (a0)+,(a1)+>,ne,error_exit	;ʎqvȂ
		next
	endif

;󂯎
	moveq.l	#0,d4
	move.b	P1_CHAR(sp),d4		;d4.w=ʃ[h
	if	<tst.w P2_TYPE(sp)>,pl
		move.b	P2_CHAR(sp),d5		;d5.b=OtBbNʂ\邩
	endif

;͈̔͂mF
	moveq.l	#$FE,d2			;d2=ʃ[h̍ől
	move.w	#$76FF,d1		;ʃ[h̍ől̎擾݂
	IOCS	_CRTMOD
	rol.l	#8,d0
	if	<cmp.b #$16,d0>,eq	;擾ł
		ror.l	#8,d0
		move.b	d0,d2			;ʃ[h̍ől
	endif
	moveq.l	#2,d0			;'͈͊Oł'
	goto	<cmp.b d2,d4>,hi,error_exit	;ʃ[h͈͊O
	goto	<cmp.b #1,d5>,hi,error_exit	;OtBbNʂ\邩͈͊O

;t@NV\
	move.w	#3,-(sp)		;ʂ̍s
	move.w	#14,-(sp)		;t@NV\s̃[h̎擾Ɛݒ
	DOS	_CONCTRL
	addq.l	#4,sp

;ʃ[hݒ肷
	move.w	d4,d1
	IOCS	_CRTMOD

;OtBbNʂ\
	if	<tst.b d5>,ne
		IOCS	_G_CLR_ON
	endif

;basic.x̃[NGAݒ肷
	moveq.l	#-1,d1
	moveq.l	#-1,d2
	IOCS	_B_CONSOL
	move.w	d2,d3			;d3.w=s-1
	swap.w	d2			;d2.w=-1
	move.w	#-1,($00A13A)bas	;screen̉ʃ[hԍBTCY<<3|ʂƐF<<1|𑜓xB-1=ݒ
	clr.w	($00A13C)bas		;ŏsYW
	move.w	d3,($00A13E)bas		;ŉsYW
	clr.w	($00A140)bas		;t@NV\s̗L
	addq.w	#1,d2			;d2.w=
	addq.w	#1,d3			;d3.w=s
	move.w	d2,($00918E)bas		;ʂ̌
	move.w	d3,($009190)bas		;ʂ̍s
	addq.w	#1,d2			;d2.w=+1
	add.w	d2,d2			;d2.w=2*(+1)
	ext.l	d2			;d2.l=2*(+1)
	move.l	d2,($009192)bas		;eLXgʃobt@ỸItZbg
	move.l	#text_buffer,($009196)bas	;eLXgʃobt@̐擪AhX

;eLXgʃobt@
	jsr	($00625E)bas		;CTRL+L CLR eLXgʂ

;߂l0
	moveq.l	#0,d0

;I
;<d0.l:߂l
normal_exit:
	lea.l	return_value(pc),a0	;߂lBvoid̂Ƃ͕sv
	move.l	d0,R1_INT(a0)		;߂l
	moveq.l	#0,d0			;IR[h0BG[bZ[W͕sv
	rts

;G[I
;<d0.l:G[R[hB0ȊOBDOSR[G[
error_exit:
	lea.l	return_value(pc),a0	;߂lBvoid̂Ƃ͕sv
	move.l	d0,R1_INT(a0)		;error off̂Ƃ̖߂lBG[R[h
	lea.l	error_message(pc),a1	;G[bZ[WBDOSR[G[̂Ƃ͕sv
	move.w	d0,d1
	subq.w	#2,d1
	if	pl
		for	d1
			do
				tst.b	(a1)+
			while	ne
		next
	endif
	rts

;G[bZ[W
error_message:
	.dc.b	'X-BASIC̃o[WႢ܂',0	;1
	.dc.b	'͈͊Oł',0			;2
	.even

;ʎq
basic202:
	.dc.b	'V2.02-8906    '

	.bss
	.even

;߂lBvoid̂Ƃ͕sv
return_value:
	.ds.b	R1_SIZE

;basic.x̐擪+$8000
basic_base:
	.ds.l	1

;eLXgʃobt@
;	basic.x̃obt@9632s𒴂Ȃ̂ŐVmۂ
text_buffer:
	.ds.w	(128+1)*64
